using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


namespace _c_dzekVrabac_K2025
{
    internal class Program
    {
        struct Jarbol
        {
            public int x;
            public int h;
            public int index;
        }

        private sealed class FastScanner
        {
            private readonly byte[] bajtovi = new byte[1 << 16];
            private int duzina, pokazivac;

            private int Citaj()
            {
                if (pokazivac >= duzina)
                {
                    duzina = Console.OpenStandardInput().Read(bajtovi, 0, bajtovi.Length);
                    pokazivac = 0;
                    if (duzina == 0) return -1;
                }
                return bajtovi[pokazivac++];
            }

            public int NextInt()
            {
                int c;
                do c = Citaj(); while (c <= ' '); 

                int sign = 1;
                if (c == '-')
                {
                    sign = -1;
                    c = Citaj();
                }

                int x = 0;
                while (c > ' ')
                {
                    x = x * 10 + (c - '0');
                    c = Citaj();
                }
                return x * sign;
            }
        }

        static void FG(Jarbol[] jarboli, out int[] sledeci, out int[] prethodni, int n)
        {
            sledeci = new int[n];
            prethodni = new int[n];

            Array.Fill(sledeci, -1);
            Array.Fill(prethodni, -1);

            int[] stek = new int[n];
            int top = 0;

            for (int i = 0; i < n; i++)
            {
                while (top > 0 && jarboli[i].h >= jarboli[stek[top - 1]].h)
                {
                    int index = stek[--top];
                    sledeci[index] = i;
                }
                stek[top++] = i;
            }

            top = 0;
            for (int i = n - 1; i >= 0; i--)
            {
                while (top > 0 && jarboli[i].h >= jarboli[stek[top - 1]].h)
                {
                    int index = stek[--top];
                    prethodni[index] = i;
                }
                stek[top++] = i;
            }
        }

        static void Main(string[] args)
        {
            var fs = new FastScanner();

            int n = fs.NextInt(); 

            Jarbol[] jarboli = new Jarbol[n];
            int[] x = new int[n];
            int[] h = new int[n];

            
            for (int i = 0; i < n; i++) x[i] = fs.NextInt();
            for (int i = 0; i < n; i++) h[i] = fs.NextInt();

            for (int i = 0; i < n; i++)
                jarboli[i] = new Jarbol { x = x[i], h = h[i], index = i };

            Array.Sort(jarboli, (a, b) => a.x.CompareTo(b.x));

            int[] sledeci, prethodni;
            FG(jarboli, out sledeci, out prethodni, n);

            int[] res = new int[n];

            for (int i = 0; i < n; i++)
            {
                int originalni = jarboli[i].index;
                int p = prethodni[i];
                int s = sledeci[i];

                long resenje = long.MaxValue;

                if (s != -1)
                {
                    long tacka = (long)jarboli[s].x - jarboli[i].x - jarboli[s].h + jarboli[i].h;
                    if (tacka < resenje) resenje = tacka;
                }

                if (p != -1)
                {
                    long tacka = (long)jarboli[i].x - jarboli[p].x - jarboli[p].h + jarboli[i].h;
                    if (tacka < resenje) resenje = tacka;
                }

                res[originalni] = (resenje == long.MaxValue) ? -1 : (int)resenje;
            }

            var sb = new StringBuilder(n * 6);
            for (int i = 0; i < n; i++)
                sb.AppendLine(res[i].ToString());

            Console.Write(sb);
        }
    }
}